/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import com.mojang.logging.LogUtils;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.slf4j.Logger;

public record RedirectShadowMethod(MethodQualifier original, MethodQualifier replacement, BiConsumer<MethodInsnNode, InsnList> callFixer) implements ClassTransform
{
    private static final Logger LOGGER = LogUtils.getLogger();

    public RedirectShadowMethod(String original, String replacement, BiConsumer<MethodInsnNode, InsnList> callFixer) {
        this(MethodQualifier.create(original).orElseThrow(), MethodQualifier.create(replacement).orElseThrow(), callFixer);
    }

    @Override
    public Patch.Result apply(ClassNode classNode, @Nullable AnnotationValueHandle<?> annotation, PatchContext context) {
        for (MethodNode method : classNode.methods) {
            MethodQualifier qualifier = new MethodQualifier(method.name, method.desc);
            if (!this.original.equals(qualifier) || method.visibleAnnotations == null) continue;
            for (AnnotationNode methodAnn : method.visibleAnnotations) {
                if (!"Lorg/spongepowered/asm/mixin/Shadow;".equals(methodAnn.desc)) continue;
                LOGGER.info(PatchInstance.MIXINPATCH, "Redirecting shadow method {}.{} to {}{}", new Object[]{classNode.name, method.name, this.replacement.name(), this.replacement.desc()});
                method.name = this.replacement.name();
                method.desc = this.replacement.desc();
                this.patchMethodCalls(classNode);
                return Patch.Result.APPLY;
            }
        }
        return Patch.Result.PASS;
    }

    private void patchMethodCalls(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            for (AbstractInsnNode insn : method.instructions) {
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode minsn = (MethodInsnNode)insn;
                if (!minsn.owner.equals(classNode.name) || !minsn.name.equals(this.original.name()) || !minsn.desc.equals(this.original.desc())) continue;
                minsn.name = this.replacement.name();
                minsn.desc = this.replacement.desc();
                this.callFixer.accept(minsn, method.instructions);
            }
        }
    }
}

